package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.KinesisVideoArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class KinesisVideoStream(arn: Option[KinesisVideoArn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.KinesisVideoStream = {
    import KinesisVideoStream.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.KinesisVideoStream
      .builder()
      .optionallyWith(
        arn.map(value => KinesisVideoArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.KinesisVideoStream.ReadOnly =
    zio.aws.rekognition.model.KinesisVideoStream.wrap(buildAwsValue())
}
object KinesisVideoStream {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.KinesisVideoStream
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.KinesisVideoStream =
      zio.aws.rekognition.model.KinesisVideoStream(arn.map(value => value))
    def arn: Option[KinesisVideoArn]
    def getArn: ZIO[Any, AwsError, KinesisVideoArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.KinesisVideoStream
  ) extends zio.aws.rekognition.model.KinesisVideoStream.ReadOnly {
    override val arn: Option[KinesisVideoArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.rekognition.model.primitives.KinesisVideoArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.KinesisVideoStream
  ): zio.aws.rekognition.model.KinesisVideoStream.ReadOnly = new Wrapper(impl)
}
