package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.KinesisDataArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class KinesisDataStream(arn: Option[KinesisDataArn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.KinesisDataStream = {
    import KinesisDataStream.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.KinesisDataStream
      .builder()
      .optionallyWith(
        arn.map(value => KinesisDataArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.KinesisDataStream.ReadOnly =
    zio.aws.rekognition.model.KinesisDataStream.wrap(buildAwsValue())
}
object KinesisDataStream {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.KinesisDataStream
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.KinesisDataStream =
      zio.aws.rekognition.model.KinesisDataStream(arn.map(value => value))
    def arn: Option[KinesisDataArn]
    def getArn: ZIO[Any, AwsError, KinesisDataArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.KinesisDataStream
  ) extends zio.aws.rekognition.model.KinesisDataStream.ReadOnly {
    override val arn: Option[KinesisDataArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.rekognition.model.primitives.KinesisDataArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.KinesisDataStream
  ): zio.aws.rekognition.model.KinesisDataStream.ReadOnly = new Wrapper(impl)
}
