package zio.aws.rekognition.model
import java.lang.Integer
import zio.aws.rekognition.model.primitives.{
  MaxFacesToIndex,
  ExternalImageId,
  CollectionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class IndexFacesRequest(
    collectionId: CollectionId,
    image: zio.aws.rekognition.model.Image,
    externalImageId: Option[ExternalImageId] = None,
    detectionAttributes: Option[Iterable[zio.aws.rekognition.model.Attribute]] =
      None,
    maxFaces: Option[MaxFacesToIndex] = None,
    qualityFilter: Option[zio.aws.rekognition.model.QualityFilter] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.IndexFacesRequest = {
    import IndexFacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.IndexFacesRequest
      .builder()
      .collectionId(CollectionId.unwrap(collectionId): java.lang.String)
      .image(image.buildAwsValue())
      .optionallyWith(
        externalImageId.map(value =>
          ExternalImageId.unwrap(value): java.lang.String
        )
      )(_.externalImageId)
      .optionallyWith(
        detectionAttributes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.detectionAttributesWithStrings)
      .optionallyWith(
        maxFaces.map(value => MaxFacesToIndex.unwrap(value): Integer)
      )(_.maxFaces)
      .optionallyWith(qualityFilter.map(value => value.unwrap))(_.qualityFilter)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.IndexFacesRequest.ReadOnly =
    zio.aws.rekognition.model.IndexFacesRequest.wrap(buildAwsValue())
}
object IndexFacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.IndexFacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.IndexFacesRequest =
      zio.aws.rekognition.model.IndexFacesRequest(
        collectionId,
        image.asEditable,
        externalImageId.map(value => value),
        detectionAttributes.map(value => value),
        maxFaces.map(value => value),
        qualityFilter.map(value => value)
      )
    def collectionId: CollectionId
    def image: zio.aws.rekognition.model.Image.ReadOnly
    def externalImageId: Option[ExternalImageId]
    def detectionAttributes: Option[List[zio.aws.rekognition.model.Attribute]]
    def maxFaces: Option[MaxFacesToIndex]
    def qualityFilter: Option[zio.aws.rekognition.model.QualityFilter]
    def getCollectionId: ZIO[Any, Nothing, CollectionId] =
      ZIO.succeed(collectionId)
    def getImage: ZIO[Any, Nothing, zio.aws.rekognition.model.Image.ReadOnly] =
      ZIO.succeed(image)
    def getExternalImageId: ZIO[Any, AwsError, ExternalImageId] =
      AwsError.unwrapOptionField("externalImageId", externalImageId)
    def getDetectionAttributes
        : ZIO[Any, AwsError, List[zio.aws.rekognition.model.Attribute]] =
      AwsError.unwrapOptionField("detectionAttributes", detectionAttributes)
    def getMaxFaces: ZIO[Any, AwsError, MaxFacesToIndex] =
      AwsError.unwrapOptionField("maxFaces", maxFaces)
    def getQualityFilter
        : ZIO[Any, AwsError, zio.aws.rekognition.model.QualityFilter] =
      AwsError.unwrapOptionField("qualityFilter", qualityFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.IndexFacesRequest
  ) extends zio.aws.rekognition.model.IndexFacesRequest.ReadOnly {
    override val collectionId: CollectionId =
      zio.aws.rekognition.model.primitives.CollectionId(impl.collectionId())
    override val image: zio.aws.rekognition.model.Image.ReadOnly =
      zio.aws.rekognition.model.Image.wrap(impl.image())
    override val externalImageId: Option[ExternalImageId] = scala
      .Option(impl.externalImageId())
      .map(value => zio.aws.rekognition.model.primitives.ExternalImageId(value))
    override val detectionAttributes
        : Option[List[zio.aws.rekognition.model.Attribute]] = scala
      .Option(impl.detectionAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.Attribute.wrap(item)
        }.toList
      )
    override val maxFaces: Option[MaxFacesToIndex] = scala
      .Option(impl.maxFaces())
      .map(value => zio.aws.rekognition.model.primitives.MaxFacesToIndex(value))
    override val qualityFilter
        : Option[zio.aws.rekognition.model.QualityFilter] = scala
      .Option(impl.qualityFilter())
      .map(value => zio.aws.rekognition.model.QualityFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.IndexFacesRequest
  ): zio.aws.rekognition.model.IndexFacesRequest.ReadOnly = new Wrapper(impl)
}
