package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Percent
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Gender(
    value: Option[zio.aws.rekognition.model.GenderType] = None,
    confidence: Option[Percent] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.Gender = {
    import Gender.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.Gender
      .builder()
      .optionallyWith(value.map(value => value.unwrap))(_.value)
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.Gender.ReadOnly =
    zio.aws.rekognition.model.Gender.wrap(buildAwsValue())
}
object Gender {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.Gender
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.Gender = zio.aws.rekognition.model
      .Gender(value.map(value => value), confidence.map(value => value))
    def value: Option[zio.aws.rekognition.model.GenderType]
    def confidence: Option[Percent]
    def getValue: ZIO[Any, AwsError, zio.aws.rekognition.model.GenderType] =
      AwsError.unwrapOptionField("value", value)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.Gender
  ) extends zio.aws.rekognition.model.Gender.ReadOnly {
    override val value: Option[zio.aws.rekognition.model.GenderType] = scala
      .Option(impl.value())
      .map(value => zio.aws.rekognition.model.GenderType.wrap(value))
    override val confidence: Option[Percent] = scala
      .Option(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.Gender
  ): zio.aws.rekognition.model.Gender.ReadOnly = new Wrapper(impl)
}
