package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Percent
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FaceMatch(
    similarity: Option[Percent] = None,
    face: Option[zio.aws.rekognition.model.Face] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.FaceMatch = {
    import FaceMatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.FaceMatch
      .builder()
      .optionallyWith(
        similarity.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.similarity)
      .optionallyWith(face.map(value => value.buildAwsValue()))(_.face)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.FaceMatch.ReadOnly =
    zio.aws.rekognition.model.FaceMatch.wrap(buildAwsValue())
}
object FaceMatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.FaceMatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.FaceMatch =
      zio.aws.rekognition.model.FaceMatch(
        similarity.map(value => value),
        face.map(value => value.asEditable)
      )
    def similarity: Option[Percent]
    def face: Option[zio.aws.rekognition.model.Face.ReadOnly]
    def getSimilarity: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("similarity", similarity)
    def getFace: ZIO[Any, AwsError, zio.aws.rekognition.model.Face.ReadOnly] =
      AwsError.unwrapOptionField("face", face)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.FaceMatch
  ) extends zio.aws.rekognition.model.FaceMatch.ReadOnly {
    override val similarity: Option[Percent] = scala
      .Option(impl.similarity())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val face: Option[zio.aws.rekognition.model.Face.ReadOnly] = scala
      .Option(impl.face())
      .map(value => zio.aws.rekognition.model.Face.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.FaceMatch
  ): zio.aws.rekognition.model.FaceMatch.ReadOnly = new Wrapper(impl)
}
