package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  Percent,
  FaceId,
  ExternalImageId,
  IndexFacesModelVersion,
  ImageId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Face(
    faceId: Option[FaceId] = None,
    boundingBox: Option[zio.aws.rekognition.model.BoundingBox] = None,
    imageId: Option[ImageId] = None,
    externalImageId: Option[ExternalImageId] = None,
    confidence: Option[Percent] = None,
    indexFacesModelVersion: Option[IndexFacesModelVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.Face = {
    import Face.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.Face
      .builder()
      .optionallyWith(
        faceId.map(value => FaceId.unwrap(value): java.lang.String)
      )(_.faceId)
      .optionallyWith(boundingBox.map(value => value.buildAwsValue()))(
        _.boundingBox
      )
      .optionallyWith(
        imageId.map(value => ImageId.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(
        externalImageId.map(value =>
          ExternalImageId.unwrap(value): java.lang.String
        )
      )(_.externalImageId)
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .optionallyWith(
        indexFacesModelVersion.map(value =>
          IndexFacesModelVersion.unwrap(value): java.lang.String
        )
      )(_.indexFacesModelVersion)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.Face.ReadOnly =
    zio.aws.rekognition.model.Face.wrap(buildAwsValue())
}
object Face {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rekognition.model.Face] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.Face =
      zio.aws.rekognition.model.Face(
        faceId.map(value => value),
        boundingBox.map(value => value.asEditable),
        imageId.map(value => value),
        externalImageId.map(value => value),
        confidence.map(value => value),
        indexFacesModelVersion.map(value => value)
      )
    def faceId: Option[FaceId]
    def boundingBox: Option[zio.aws.rekognition.model.BoundingBox.ReadOnly]
    def imageId: Option[ImageId]
    def externalImageId: Option[ExternalImageId]
    def confidence: Option[Percent]
    def indexFacesModelVersion: Option[IndexFacesModelVersion]
    def getFaceId: ZIO[Any, AwsError, FaceId] =
      AwsError.unwrapOptionField("faceId", faceId)
    def getBoundingBox
        : ZIO[Any, AwsError, zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      AwsError.unwrapOptionField("boundingBox", boundingBox)
    def getImageId: ZIO[Any, AwsError, ImageId] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getExternalImageId: ZIO[Any, AwsError, ExternalImageId] =
      AwsError.unwrapOptionField("externalImageId", externalImageId)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getIndexFacesModelVersion: ZIO[Any, AwsError, IndexFacesModelVersion] =
      AwsError.unwrapOptionField(
        "indexFacesModelVersion",
        indexFacesModelVersion
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.Face
  ) extends zio.aws.rekognition.model.Face.ReadOnly {
    override val faceId: Option[FaceId] = scala
      .Option(impl.faceId())
      .map(value => zio.aws.rekognition.model.primitives.FaceId(value))
    override val boundingBox
        : Option[zio.aws.rekognition.model.BoundingBox.ReadOnly] = scala
      .Option(impl.boundingBox())
      .map(value => zio.aws.rekognition.model.BoundingBox.wrap(value))
    override val imageId: Option[ImageId] = scala
      .Option(impl.imageId())
      .map(value => zio.aws.rekognition.model.primitives.ImageId(value))
    override val externalImageId: Option[ExternalImageId] = scala
      .Option(impl.externalImageId())
      .map(value => zio.aws.rekognition.model.primitives.ExternalImageId(value))
    override val confidence: Option[Percent] = scala
      .Option(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val indexFacesModelVersion: Option[IndexFacesModelVersion] = scala
      .Option(impl.indexFacesModelVersion())
      .map(value =>
        zio.aws.rekognition.model.primitives.IndexFacesModelVersion(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.Face
  ): zio.aws.rekognition.model.Face.ReadOnly = new Wrapper(impl)
}
