package zio.aws.rekognition.model
import java.lang.Integer
import zio.aws.rekognition.model.primitives.{
  Percent,
  UInteger,
  ProjectVersionArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DetectCustomLabelsRequest(
    projectVersionArn: ProjectVersionArn,
    image: zio.aws.rekognition.model.Image,
    maxResults: Option[UInteger] = None,
    minConfidence: Option[Percent] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DetectCustomLabelsRequest = {
    import DetectCustomLabelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DetectCustomLabelsRequest
      .builder()
      .projectVersionArn(
        ProjectVersionArn.unwrap(projectVersionArn): java.lang.String
      )
      .image(image.buildAwsValue())
      .optionallyWith(maxResults.map(value => UInteger.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(
        minConfidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.minConfidence)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DetectCustomLabelsRequest.ReadOnly =
    zio.aws.rekognition.model.DetectCustomLabelsRequest.wrap(buildAwsValue())
}
object DetectCustomLabelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DetectCustomLabelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DetectCustomLabelsRequest =
      zio.aws.rekognition.model.DetectCustomLabelsRequest(
        projectVersionArn,
        image.asEditable,
        maxResults.map(value => value),
        minConfidence.map(value => value)
      )
    def projectVersionArn: ProjectVersionArn
    def image: zio.aws.rekognition.model.Image.ReadOnly
    def maxResults: Option[UInteger]
    def minConfidence: Option[Percent]
    def getProjectVersionArn: ZIO[Any, Nothing, ProjectVersionArn] =
      ZIO.succeed(projectVersionArn)
    def getImage: ZIO[Any, Nothing, zio.aws.rekognition.model.Image.ReadOnly] =
      ZIO.succeed(image)
    def getMaxResults: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getMinConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("minConfidence", minConfidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DetectCustomLabelsRequest
  ) extends zio.aws.rekognition.model.DetectCustomLabelsRequest.ReadOnly {
    override val projectVersionArn: ProjectVersionArn =
      zio.aws.rekognition.model.primitives
        .ProjectVersionArn(impl.projectVersionArn())
    override val image: zio.aws.rekognition.model.Image.ReadOnly =
      zio.aws.rekognition.model.Image.wrap(impl.image())
    override val maxResults: Option[UInteger] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.rekognition.model.primitives.UInteger(value))
    override val minConfidence: Option[Percent] = scala
      .Option(impl.minConfidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DetectCustomLabelsRequest
  ): zio.aws.rekognition.model.DetectCustomLabelsRequest.ReadOnly = new Wrapper(
    impl
  )
}
