package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{DateTime, ULong}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeCollectionResponse(
    faceCount: Option[ULong] = None,
    faceModelVersion: Option[String] = None,
    collectionARN: Option[String] = None,
    creationTimestamp: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DescribeCollectionResponse = {
    import DescribeCollectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DescribeCollectionResponse
      .builder()
      .optionallyWith(
        faceCount.map(value => ULong.unwrap(value): java.lang.Long)
      )(_.faceCount)
      .optionallyWith(faceModelVersion.map(value => value: java.lang.String))(
        _.faceModelVersion
      )
      .optionallyWith(collectionARN.map(value => value: java.lang.String))(
        _.collectionARN
      )
      .optionallyWith(
        creationTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTimestamp)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.DescribeCollectionResponse.ReadOnly =
    zio.aws.rekognition.model.DescribeCollectionResponse.wrap(buildAwsValue())
}
object DescribeCollectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DescribeCollectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DescribeCollectionResponse =
      zio.aws.rekognition.model.DescribeCollectionResponse(
        faceCount.map(value => value),
        faceModelVersion.map(value => value),
        collectionARN.map(value => value),
        creationTimestamp.map(value => value)
      )
    def faceCount: Option[ULong]
    def faceModelVersion: Option[String]
    def collectionARN: Option[String]
    def creationTimestamp: Option[DateTime]
    def getFaceCount: ZIO[Any, AwsError, ULong] =
      AwsError.unwrapOptionField("faceCount", faceCount)
    def getFaceModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("faceModelVersion", faceModelVersion)
    def getCollectionARN: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("collectionARN", collectionARN)
    def getCreationTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DescribeCollectionResponse
  ) extends zio.aws.rekognition.model.DescribeCollectionResponse.ReadOnly {
    override val faceCount: Option[ULong] = scala
      .Option(impl.faceCount())
      .map(value => zio.aws.rekognition.model.primitives.ULong(value))
    override val faceModelVersion: Option[String] =
      scala.Option(impl.faceModelVersion()).map(value => value: String)
    override val collectionARN: Option[String] =
      scala.Option(impl.collectionARN()).map(value => value: String)
    override val creationTimestamp: Option[DateTime] = scala
      .Option(impl.creationTimestamp())
      .map(value => zio.aws.rekognition.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DescribeCollectionResponse
  ): zio.aws.rekognition.model.DescribeCollectionResponse.ReadOnly =
    new Wrapper(impl)
}
