package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.CollectionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteCollectionRequest(collectionId: CollectionId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DeleteCollectionRequest = {
    import DeleteCollectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DeleteCollectionRequest
      .builder()
      .collectionId(CollectionId.unwrap(collectionId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DeleteCollectionRequest.ReadOnly =
    zio.aws.rekognition.model.DeleteCollectionRequest.wrap(buildAwsValue())
}
object DeleteCollectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DeleteCollectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DeleteCollectionRequest =
      zio.aws.rekognition.model.DeleteCollectionRequest(collectionId)
    def collectionId: CollectionId
    def getCollectionId: ZIO[Any, Nothing, CollectionId] =
      ZIO.succeed(collectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DeleteCollectionRequest
  ) extends zio.aws.rekognition.model.DeleteCollectionRequest.ReadOnly {
    override val collectionId: CollectionId =
      zio.aws.rekognition.model.primitives.CollectionId(impl.collectionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DeleteCollectionRequest
  ): zio.aws.rekognition.model.DeleteCollectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
