package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Percent
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CustomLabel(
    name: Option[String] = None,
    confidence: Option[Percent] = None,
    geometry: Option[zio.aws.rekognition.model.Geometry] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.CustomLabel = {
    import CustomLabel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.CustomLabel
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .optionallyWith(geometry.map(value => value.buildAwsValue()))(_.geometry)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.CustomLabel.ReadOnly =
    zio.aws.rekognition.model.CustomLabel.wrap(buildAwsValue())
}
object CustomLabel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.CustomLabel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.CustomLabel =
      zio.aws.rekognition.model.CustomLabel(
        name.map(value => value),
        confidence.map(value => value),
        geometry.map(value => value.asEditable)
      )
    def name: Option[String]
    def confidence: Option[Percent]
    def geometry: Option[zio.aws.rekognition.model.Geometry.ReadOnly]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getGeometry
        : ZIO[Any, AwsError, zio.aws.rekognition.model.Geometry.ReadOnly] =
      AwsError.unwrapOptionField("geometry", geometry)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.CustomLabel
  ) extends zio.aws.rekognition.model.CustomLabel.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val confidence: Option[Percent] = scala
      .Option(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val geometry: Option[zio.aws.rekognition.model.Geometry.ReadOnly] =
      scala
        .Option(impl.geometry())
        .map(value => zio.aws.rekognition.model.Geometry.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.CustomLabel
  ): zio.aws.rekognition.model.CustomLabel.ReadOnly = new Wrapper(impl)
}
