package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ContentModerationDetection(
    timestamp: Option[Timestamp] = None,
    moderationLabel: Option[zio.aws.rekognition.model.ModerationLabel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ContentModerationDetection = {
    import ContentModerationDetection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ContentModerationDetection
      .builder()
      .optionallyWith(
        timestamp.map(value => Timestamp.unwrap(value): java.lang.Long)
      )(_.timestamp)
      .optionallyWith(moderationLabel.map(value => value.buildAwsValue()))(
        _.moderationLabel
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.ContentModerationDetection.ReadOnly =
    zio.aws.rekognition.model.ContentModerationDetection.wrap(buildAwsValue())
}
object ContentModerationDetection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ContentModerationDetection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ContentModerationDetection =
      zio.aws.rekognition.model.ContentModerationDetection(
        timestamp.map(value => value),
        moderationLabel.map(value => value.asEditable)
      )
    def timestamp: Option[Timestamp]
    def moderationLabel
        : Option[zio.aws.rekognition.model.ModerationLabel.ReadOnly]
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getModerationLabel: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.ModerationLabel.ReadOnly
    ] = AwsError.unwrapOptionField("moderationLabel", moderationLabel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ContentModerationDetection
  ) extends zio.aws.rekognition.model.ContentModerationDetection.ReadOnly {
    override val timestamp: Option[Timestamp] = scala
      .Option(impl.timestamp())
      .map(value => zio.aws.rekognition.model.primitives.Timestamp(value))
    override val moderationLabel
        : Option[zio.aws.rekognition.model.ModerationLabel.ReadOnly] = scala
      .Option(impl.moderationLabel())
      .map(value => zio.aws.rekognition.model.ModerationLabel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ContentModerationDetection
  ): zio.aws.rekognition.model.ContentModerationDetection.ReadOnly =
    new Wrapper(impl)
}
