package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BoundingBox(
    width: Option[Float] = None,
    height: Option[Float] = None,
    left: Option[Float] = None,
    top: Option[Float] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.BoundingBox = {
    import BoundingBox.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.BoundingBox
      .builder()
      .optionallyWith(width.map(value => value: java.lang.Float))(_.width)
      .optionallyWith(height.map(value => value: java.lang.Float))(_.height)
      .optionallyWith(left.map(value => value: java.lang.Float))(_.left)
      .optionallyWith(top.map(value => value: java.lang.Float))(_.top)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.BoundingBox.ReadOnly =
    zio.aws.rekognition.model.BoundingBox.wrap(buildAwsValue())
}
object BoundingBox {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.BoundingBox
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.BoundingBox =
      zio.aws.rekognition.model.BoundingBox(
        width.map(value => value),
        height.map(value => value),
        left.map(value => value),
        top.map(value => value)
      )
    def width: Option[Float]
    def height: Option[Float]
    def left: Option[Float]
    def top: Option[Float]
    def getWidth: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("width", width)
    def getHeight: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("height", height)
    def getLeft: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("left", left)
    def getTop: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("top", top)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.BoundingBox
  ) extends zio.aws.rekognition.model.BoundingBox.ReadOnly {
    override val width: Option[Float] =
      scala.Option(impl.width()).map(value => value: Float)
    override val height: Option[Float] =
      scala.Option(impl.height()).map(value => value: Float)
    override val left: Option[Float] =
      scala.Option(impl.left()).map(value => value: Float)
    override val top: Option[Float] =
      scala.Option(impl.top()).map(value => value: Float)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.BoundingBox
  ): zio.aws.rekognition.model.BoundingBox.ReadOnly = new Wrapper(impl)
}
