package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait BodyPart {
  def unwrap: software.amazon.awssdk.services.rekognition.model.BodyPart
}
object BodyPart {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.BodyPart
  ): zio.aws.rekognition.model.BodyPart = value match {
    case software.amazon.awssdk.services.rekognition.model.BodyPart.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rekognition.model.BodyPart.FACE =>
      val r = FACE
      r
    case software.amazon.awssdk.services.rekognition.model.BodyPart.HEAD =>
      val r = HEAD
      r
    case software.amazon.awssdk.services.rekognition.model.BodyPart.LEFT_HAND =>
      val r = LEFT_HAND
      r
    case software.amazon.awssdk.services.rekognition.model.BodyPart.RIGHT_HAND =>
      val r = RIGHT_HAND
      r
  }
  case object unknownToSdkVersion extends zio.aws.rekognition.model.BodyPart {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.BodyPart =
      software.amazon.awssdk.services.rekognition.model.BodyPart.UNKNOWN_TO_SDK_VERSION
  }
  case object FACE extends zio.aws.rekognition.model.BodyPart {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.BodyPart =
      software.amazon.awssdk.services.rekognition.model.BodyPart.FACE
  }
  case object HEAD extends zio.aws.rekognition.model.BodyPart {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.BodyPart =
      software.amazon.awssdk.services.rekognition.model.BodyPart.HEAD
  }
  case object LEFT_HAND extends zio.aws.rekognition.model.BodyPart {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.BodyPart =
      software.amazon.awssdk.services.rekognition.model.BodyPart.LEFT_HAND
  }
  case object RIGHT_HAND extends zio.aws.rekognition.model.BodyPart {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.BodyPart =
      software.amazon.awssdk.services.rekognition.model.BodyPart.RIGHT_HAND
  }
}
