package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.JobId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartSegmentDetectionResponse(jobId: Option[JobId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StartSegmentDetectionResponse = {
    import StartSegmentDetectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StartSegmentDetectionResponse
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.StartSegmentDetectionResponse.ReadOnly =
    zio.aws.rekognition.model.StartSegmentDetectionResponse
      .wrap(buildAwsValue())
}
object StartSegmentDetectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StartSegmentDetectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StartSegmentDetectionResponse =
      zio.aws.rekognition.model
        .StartSegmentDetectionResponse(jobId.map(value => value))
    def jobId: Option[JobId]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StartSegmentDetectionResponse
  ) extends zio.aws.rekognition.model.StartSegmentDetectionResponse.ReadOnly {
    override val jobId: Option[JobId] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.rekognition.model.primitives.JobId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StartSegmentDetectionResponse
  ): zio.aws.rekognition.model.StartSegmentDetectionResponse.ReadOnly =
    new Wrapper(impl)
}
