package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.JobId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartLabelDetectionResponse(jobId: Option[JobId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StartLabelDetectionResponse = {
    import StartLabelDetectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StartLabelDetectionResponse
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.StartLabelDetectionResponse.ReadOnly =
    zio.aws.rekognition.model.StartLabelDetectionResponse.wrap(buildAwsValue())
}
object StartLabelDetectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StartLabelDetectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StartLabelDetectionResponse =
      zio.aws.rekognition.model
        .StartLabelDetectionResponse(jobId.map(value => value))
    def jobId: Option[JobId]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StartLabelDetectionResponse
  ) extends zio.aws.rekognition.model.StartLabelDetectionResponse.ReadOnly {
    override val jobId: Option[JobId] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.rekognition.model.primitives.JobId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StartLabelDetectionResponse
  ): zio.aws.rekognition.model.StartLabelDetectionResponse.ReadOnly =
    new Wrapper(impl)
}
