package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  S3ObjectVersion,
  S3ObjectName,
  S3Bucket
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class S3Object(
    bucket: Option[S3Bucket] = None,
    name: Option[S3ObjectName] = None,
    version: Option[S3ObjectVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.S3Object = {
    import S3Object.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.S3Object
      .builder()
      .optionallyWith(
        bucket.map(value => S3Bucket.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(
        name.map(value => S3ObjectName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        version.map(value => S3ObjectVersion.unwrap(value): java.lang.String)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.S3Object.ReadOnly =
    zio.aws.rekognition.model.S3Object.wrap(buildAwsValue())
}
object S3Object {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.S3Object
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.S3Object =
      zio.aws.rekognition.model.S3Object(
        bucket.map(value => value),
        name.map(value => value),
        version.map(value => value)
      )
    def bucket: Option[S3Bucket]
    def name: Option[S3ObjectName]
    def version: Option[S3ObjectVersion]
    def getBucket: ZIO[Any, AwsError, S3Bucket] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getName: ZIO[Any, AwsError, S3ObjectName] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, S3ObjectVersion] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.S3Object
  ) extends zio.aws.rekognition.model.S3Object.ReadOnly {
    override val bucket: Option[S3Bucket] = scala
      .Option(impl.bucket())
      .map(value => zio.aws.rekognition.model.primitives.S3Bucket(value))
    override val name: Option[S3ObjectName] = scala
      .Option(impl.name())
      .map(value => zio.aws.rekognition.model.primitives.S3ObjectName(value))
    override val version: Option[S3ObjectVersion] = scala
      .Option(impl.version())
      .map(value => zio.aws.rekognition.model.primitives.S3ObjectVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.S3Object
  ): zio.aws.rekognition.model.S3Object.ReadOnly = new Wrapper(impl)
}
