package zio.aws.rekognition.model
import java.lang.Integer
import zio.aws.rekognition.model.primitives.{UInteger, Percent}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ProtectiveEquipmentPerson(
    bodyParts: Option[
      Iterable[zio.aws.rekognition.model.ProtectiveEquipmentBodyPart]
    ] = None,
    boundingBox: Option[zio.aws.rekognition.model.BoundingBox] = None,
    confidence: Option[Percent] = None,
    id: Option[UInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentPerson = {
    import ProtectiveEquipmentPerson.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentPerson
      .builder()
      .optionallyWith(
        bodyParts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bodyParts)
      .optionallyWith(boundingBox.map(value => value.buildAwsValue()))(
        _.boundingBox
      )
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .optionallyWith(id.map(value => UInteger.unwrap(value): Integer))(_.id)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.ProtectiveEquipmentPerson.ReadOnly =
    zio.aws.rekognition.model.ProtectiveEquipmentPerson.wrap(buildAwsValue())
}
object ProtectiveEquipmentPerson {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentPerson
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ProtectiveEquipmentPerson =
      zio.aws.rekognition.model.ProtectiveEquipmentPerson(
        bodyParts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        boundingBox.map(value => value.asEditable),
        confidence.map(value => value),
        id.map(value => value)
      )
    def bodyParts: Option[
      List[zio.aws.rekognition.model.ProtectiveEquipmentBodyPart.ReadOnly]
    ]
    def boundingBox: Option[zio.aws.rekognition.model.BoundingBox.ReadOnly]
    def confidence: Option[Percent]
    def id: Option[UInteger]
    def getBodyParts: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.ProtectiveEquipmentBodyPart.ReadOnly
    ]] = AwsError.unwrapOptionField("bodyParts", bodyParts)
    def getBoundingBox
        : ZIO[Any, AwsError, zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      AwsError.unwrapOptionField("boundingBox", boundingBox)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getId: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentPerson
  ) extends zio.aws.rekognition.model.ProtectiveEquipmentPerson.ReadOnly {
    override val bodyParts: Option[
      List[zio.aws.rekognition.model.ProtectiveEquipmentBodyPart.ReadOnly]
    ] = scala
      .Option(impl.bodyParts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.ProtectiveEquipmentBodyPart.wrap(item)
        }.toList
      )
    override val boundingBox
        : Option[zio.aws.rekognition.model.BoundingBox.ReadOnly] = scala
      .Option(impl.boundingBox())
      .map(value => zio.aws.rekognition.model.BoundingBox.wrap(value))
    override val confidence: Option[Percent] = scala
      .Option(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val id: Option[UInteger] = scala
      .Option(impl.id())
      .map(value => zio.aws.rekognition.model.primitives.UInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentPerson
  ): zio.aws.rekognition.model.ProtectiveEquipmentPerson.ReadOnly = new Wrapper(
    impl
  )
}
