package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Parent(name: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.Parent = {
    import Parent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.Parent
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.Parent.ReadOnly =
    zio.aws.rekognition.model.Parent.wrap(buildAwsValue())
}
object Parent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.Parent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.Parent =
      zio.aws.rekognition.model.Parent(name.map(value => value))
    def name: Option[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.Parent
  ) extends zio.aws.rekognition.model.Parent.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.Parent
  ): zio.aws.rekognition.model.Parent.ReadOnly = new Wrapper(impl)
}
