package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListStreamProcessorsResponse(
    nextToken: Option[PaginationToken] = None,
    streamProcessors: Option[
      Iterable[zio.aws.rekognition.model.StreamProcessor]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsResponse = {
    import ListStreamProcessorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        streamProcessors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.streamProcessors)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.ListStreamProcessorsResponse.ReadOnly =
    zio.aws.rekognition.model.ListStreamProcessorsResponse.wrap(buildAwsValue())
}
object ListStreamProcessorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ListStreamProcessorsResponse =
      zio.aws.rekognition.model.ListStreamProcessorsResponse(
        nextToken.map(value => value),
        streamProcessors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[PaginationToken]
    def streamProcessors
        : Option[List[zio.aws.rekognition.model.StreamProcessor.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStreamProcessors: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.StreamProcessor.ReadOnly
    ]] = AwsError.unwrapOptionField("streamProcessors", streamProcessors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsResponse
  ) extends zio.aws.rekognition.model.ListStreamProcessorsResponse.ReadOnly {
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.rekognition.model.primitives.PaginationToken(value))
    override val streamProcessors
        : Option[List[zio.aws.rekognition.model.StreamProcessor.ReadOnly]] =
      scala
        .Option(impl.streamProcessors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.StreamProcessor.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsResponse
  ): zio.aws.rekognition.model.ListStreamProcessorsResponse.ReadOnly =
    new Wrapper(impl)
}
