package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{PaginationToken, StatusMessage}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetSegmentDetectionResponse(
    jobStatus: Option[zio.aws.rekognition.model.VideoJobStatus] = None,
    statusMessage: Option[StatusMessage] = None,
    videoMetadata: Option[Iterable[zio.aws.rekognition.model.VideoMetadata]] =
      None,
    audioMetadata: Option[Iterable[zio.aws.rekognition.model.AudioMetadata]] =
      None,
    nextToken: Option[PaginationToken] = None,
    segments: Option[Iterable[zio.aws.rekognition.model.SegmentDetection]] =
      None,
    selectedSegmentTypes: Option[
      Iterable[zio.aws.rekognition.model.SegmentTypeInfo]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.GetSegmentDetectionResponse = {
    import GetSegmentDetectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.GetSegmentDetectionResponse
      .builder()
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        videoMetadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.videoMetadata)
      .optionallyWith(
        audioMetadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.audioMetadata)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        segments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.segments)
      .optionallyWith(
        selectedSegmentTypes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.selectedSegmentTypes)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.GetSegmentDetectionResponse.ReadOnly =
    zio.aws.rekognition.model.GetSegmentDetectionResponse.wrap(buildAwsValue())
}
object GetSegmentDetectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.GetSegmentDetectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.GetSegmentDetectionResponse =
      zio.aws.rekognition.model.GetSegmentDetectionResponse(
        jobStatus.map(value => value),
        statusMessage.map(value => value),
        videoMetadata.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        audioMetadata.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        segments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        selectedSegmentTypes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def jobStatus: Option[zio.aws.rekognition.model.VideoJobStatus]
    def statusMessage: Option[StatusMessage]
    def videoMetadata
        : Option[List[zio.aws.rekognition.model.VideoMetadata.ReadOnly]]
    def audioMetadata
        : Option[List[zio.aws.rekognition.model.AudioMetadata.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def segments
        : Option[List[zio.aws.rekognition.model.SegmentDetection.ReadOnly]]
    def selectedSegmentTypes
        : Option[List[zio.aws.rekognition.model.SegmentTypeInfo.ReadOnly]]
    def getJobStatus
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoJobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getVideoMetadata: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.VideoMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("videoMetadata", videoMetadata)
    def getAudioMetadata: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.AudioMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("audioMetadata", audioMetadata)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSegments: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.SegmentDetection.ReadOnly
    ]] = AwsError.unwrapOptionField("segments", segments)
    def getSelectedSegmentTypes: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.SegmentTypeInfo.ReadOnly
    ]] =
      AwsError.unwrapOptionField("selectedSegmentTypes", selectedSegmentTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.GetSegmentDetectionResponse
  ) extends zio.aws.rekognition.model.GetSegmentDetectionResponse.ReadOnly {
    override val jobStatus: Option[zio.aws.rekognition.model.VideoJobStatus] =
      scala
        .Option(impl.jobStatus())
        .map(value => zio.aws.rekognition.model.VideoJobStatus.wrap(value))
    override val statusMessage: Option[StatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value => zio.aws.rekognition.model.primitives.StatusMessage(value))
    override val videoMetadata
        : Option[List[zio.aws.rekognition.model.VideoMetadata.ReadOnly]] = scala
      .Option(impl.videoMetadata())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.VideoMetadata.wrap(item)
        }.toList
      )
    override val audioMetadata
        : Option[List[zio.aws.rekognition.model.AudioMetadata.ReadOnly]] = scala
      .Option(impl.audioMetadata())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.AudioMetadata.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.rekognition.model.primitives.PaginationToken(value))
    override val segments
        : Option[List[zio.aws.rekognition.model.SegmentDetection.ReadOnly]] =
      scala
        .Option(impl.segments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.SegmentDetection.wrap(item)
          }.toList
        )
    override val selectedSegmentTypes
        : Option[List[zio.aws.rekognition.model.SegmentTypeInfo.ReadOnly]] =
      scala
        .Option(impl.selectedSegmentTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.SegmentTypeInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.GetSegmentDetectionResponse
  ): zio.aws.rekognition.model.GetSegmentDetectionResponse.ReadOnly =
    new Wrapper(impl)
}
