package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{Percent, CollectionId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FaceSearchSettings(
    collectionId: Option[CollectionId] = None,
    faceMatchThreshold: Option[Percent] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.FaceSearchSettings = {
    import FaceSearchSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.FaceSearchSettings
      .builder()
      .optionallyWith(
        collectionId.map(value => CollectionId.unwrap(value): java.lang.String)
      )(_.collectionId)
      .optionallyWith(
        faceMatchThreshold.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.faceMatchThreshold)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.FaceSearchSettings.ReadOnly =
    zio.aws.rekognition.model.FaceSearchSettings.wrap(buildAwsValue())
}
object FaceSearchSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.FaceSearchSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.FaceSearchSettings =
      zio.aws.rekognition.model.FaceSearchSettings(
        collectionId.map(value => value),
        faceMatchThreshold.map(value => value)
      )
    def collectionId: Option[CollectionId]
    def faceMatchThreshold: Option[Percent]
    def getCollectionId: ZIO[Any, AwsError, CollectionId] =
      AwsError.unwrapOptionField("collectionId", collectionId)
    def getFaceMatchThreshold: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("faceMatchThreshold", faceMatchThreshold)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.FaceSearchSettings
  ) extends zio.aws.rekognition.model.FaceSearchSettings.ReadOnly {
    override val collectionId: Option[CollectionId] = scala
      .Option(impl.collectionId())
      .map(value => zio.aws.rekognition.model.primitives.CollectionId(value))
    override val faceMatchThreshold: Option[Percent] = scala
      .Option(impl.faceMatchThreshold())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.FaceSearchSettings
  ): zio.aws.rekognition.model.FaceSearchSettings.ReadOnly = new Wrapper(impl)
}
