package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DetectTextFilters(
    wordFilter: Option[zio.aws.rekognition.model.DetectionFilter] = None,
    regionsOfInterest: Option[
      Iterable[zio.aws.rekognition.model.RegionOfInterest]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DetectTextFilters = {
    import DetectTextFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DetectTextFilters
      .builder()
      .optionallyWith(wordFilter.map(value => value.buildAwsValue()))(
        _.wordFilter
      )
      .optionallyWith(
        regionsOfInterest.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.regionsOfInterest)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DetectTextFilters.ReadOnly =
    zio.aws.rekognition.model.DetectTextFilters.wrap(buildAwsValue())
}
object DetectTextFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DetectTextFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DetectTextFilters =
      zio.aws.rekognition.model.DetectTextFilters(
        wordFilter.map(value => value.asEditable),
        regionsOfInterest.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def wordFilter: Option[zio.aws.rekognition.model.DetectionFilter.ReadOnly]
    def regionsOfInterest
        : Option[List[zio.aws.rekognition.model.RegionOfInterest.ReadOnly]]
    def getWordFilter: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.DetectionFilter.ReadOnly
    ] = AwsError.unwrapOptionField("wordFilter", wordFilter)
    def getRegionsOfInterest: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.RegionOfInterest.ReadOnly
    ]] = AwsError.unwrapOptionField("regionsOfInterest", regionsOfInterest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DetectTextFilters
  ) extends zio.aws.rekognition.model.DetectTextFilters.ReadOnly {
    override val wordFilter
        : Option[zio.aws.rekognition.model.DetectionFilter.ReadOnly] = scala
      .Option(impl.wordFilter())
      .map(value => zio.aws.rekognition.model.DetectionFilter.wrap(value))
    override val regionsOfInterest
        : Option[List[zio.aws.rekognition.model.RegionOfInterest.ReadOnly]] =
      scala
        .Option(impl.regionsOfInterest())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.RegionOfInterest.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DetectTextFilters
  ): zio.aws.rekognition.model.DetectTextFilters.ReadOnly = new Wrapper(impl)
}
