package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.DatasetLabel
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DatasetLabelDescription(
    labelName: Option[DatasetLabel] = None,
    labelStats: Option[zio.aws.rekognition.model.DatasetLabelStats] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DatasetLabelDescription = {
    import DatasetLabelDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DatasetLabelDescription
      .builder()
      .optionallyWith(
        labelName.map(value => DatasetLabel.unwrap(value): java.lang.String)
      )(_.labelName)
      .optionallyWith(labelStats.map(value => value.buildAwsValue()))(
        _.labelStats
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DatasetLabelDescription.ReadOnly =
    zio.aws.rekognition.model.DatasetLabelDescription.wrap(buildAwsValue())
}
object DatasetLabelDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DatasetLabelDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DatasetLabelDescription =
      zio.aws.rekognition.model.DatasetLabelDescription(
        labelName.map(value => value),
        labelStats.map(value => value.asEditable)
      )
    def labelName: Option[DatasetLabel]
    def labelStats: Option[zio.aws.rekognition.model.DatasetLabelStats.ReadOnly]
    def getLabelName: ZIO[Any, AwsError, DatasetLabel] =
      AwsError.unwrapOptionField("labelName", labelName)
    def getLabelStats: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.DatasetLabelStats.ReadOnly
    ] = AwsError.unwrapOptionField("labelStats", labelStats)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DatasetLabelDescription
  ) extends zio.aws.rekognition.model.DatasetLabelDescription.ReadOnly {
    override val labelName: Option[DatasetLabel] = scala
      .Option(impl.labelName())
      .map(value => zio.aws.rekognition.model.primitives.DatasetLabel(value))
    override val labelStats
        : Option[zio.aws.rekognition.model.DatasetLabelStats.ReadOnly] = scala
      .Option(impl.labelStats())
      .map(value => zio.aws.rekognition.model.DatasetLabelStats.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DatasetLabelDescription
  ): zio.aws.rekognition.model.DatasetLabelDescription.ReadOnly = new Wrapper(
    impl
  )
}
