package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  TagValue,
  TagKey,
  RoleArn,
  StreamProcessorName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateStreamProcessorRequest(
    input: zio.aws.rekognition.model.StreamProcessorInput,
    output: zio.aws.rekognition.model.StreamProcessorOutput,
    name: StreamProcessorName,
    settings: zio.aws.rekognition.model.StreamProcessorSettings,
    roleArn: RoleArn,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.CreateStreamProcessorRequest = {
    import CreateStreamProcessorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.CreateStreamProcessorRequest
      .builder()
      .input(input.buildAwsValue())
      .output(output.buildAwsValue())
      .name(StreamProcessorName.unwrap(name): java.lang.String)
      .settings(settings.buildAwsValue())
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.CreateStreamProcessorRequest.ReadOnly =
    zio.aws.rekognition.model.CreateStreamProcessorRequest.wrap(buildAwsValue())
}
object CreateStreamProcessorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.CreateStreamProcessorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.CreateStreamProcessorRequest =
      zio.aws.rekognition.model.CreateStreamProcessorRequest(
        input.asEditable,
        output.asEditable,
        name,
        settings.asEditable,
        roleArn,
        tags.map(value => value)
      )
    def input: zio.aws.rekognition.model.StreamProcessorInput.ReadOnly
    def output: zio.aws.rekognition.model.StreamProcessorOutput.ReadOnly
    def name: StreamProcessorName
    def settings: zio.aws.rekognition.model.StreamProcessorSettings.ReadOnly
    def roleArn: RoleArn
    def tags: Option[Map[TagKey, TagValue]]
    def getInput: ZIO[
      Any,
      Nothing,
      zio.aws.rekognition.model.StreamProcessorInput.ReadOnly
    ] = ZIO.succeed(input)
    def getOutput: ZIO[
      Any,
      Nothing,
      zio.aws.rekognition.model.StreamProcessorOutput.ReadOnly
    ] = ZIO.succeed(output)
    def getName: ZIO[Any, Nothing, StreamProcessorName] = ZIO.succeed(name)
    def getSettings: ZIO[
      Any,
      Nothing,
      zio.aws.rekognition.model.StreamProcessorSettings.ReadOnly
    ] = ZIO.succeed(settings)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.CreateStreamProcessorRequest
  ) extends zio.aws.rekognition.model.CreateStreamProcessorRequest.ReadOnly {
    override val input
        : zio.aws.rekognition.model.StreamProcessorInput.ReadOnly =
      zio.aws.rekognition.model.StreamProcessorInput.wrap(impl.input())
    override val output
        : zio.aws.rekognition.model.StreamProcessorOutput.ReadOnly =
      zio.aws.rekognition.model.StreamProcessorOutput.wrap(impl.output())
    override val name: StreamProcessorName =
      zio.aws.rekognition.model.primitives.StreamProcessorName(impl.name())
    override val settings
        : zio.aws.rekognition.model.StreamProcessorSettings.ReadOnly =
      zio.aws.rekognition.model.StreamProcessorSettings.wrap(impl.settings())
    override val roleArn: RoleArn =
      zio.aws.rekognition.model.primitives.RoleArn(impl.roleArn())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.rekognition.model.primitives.TagKey(
              key
            ) -> zio.aws.rekognition.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.CreateStreamProcessorRequest
  ): zio.aws.rekognition.model.CreateStreamProcessorRequest.ReadOnly =
    new Wrapper(impl)
}
