package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait VideoJobStatus {
  def unwrap: software.amazon.awssdk.services.rekognition.model.VideoJobStatus
}
object VideoJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.VideoJobStatus
  ): zio.aws.rekognition.model.VideoJobStatus = value match {
    case software.amazon.awssdk.services.rekognition.model.VideoJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rekognition.model.VideoJobStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.rekognition.model.VideoJobStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.rekognition.model.VideoJobStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rekognition.model.VideoJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.VideoJobStatus =
      software.amazon.awssdk.services.rekognition.model.VideoJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS extends zio.aws.rekognition.model.VideoJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.VideoJobStatus =
      software.amazon.awssdk.services.rekognition.model.VideoJobStatus.IN_PROGRESS
  }
  case object SUCCEEDED extends zio.aws.rekognition.model.VideoJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.VideoJobStatus =
      software.amazon.awssdk.services.rekognition.model.VideoJobStatus.SUCCEEDED
  }
  case object FAILED extends zio.aws.rekognition.model.VideoJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.VideoJobStatus =
      software.amazon.awssdk.services.rekognition.model.VideoJobStatus.FAILED
  }
}
