package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TextDetectionResult(
    timestamp: Option[Timestamp] = None,
    textDetection: Option[zio.aws.rekognition.model.TextDetection] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.TextDetectionResult = {
    import TextDetectionResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.TextDetectionResult
      .builder()
      .optionallyWith(
        timestamp.map(value => Timestamp.unwrap(value): java.lang.Long)
      )(_.timestamp)
      .optionallyWith(textDetection.map(value => value.buildAwsValue()))(
        _.textDetection
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.TextDetectionResult.ReadOnly =
    zio.aws.rekognition.model.TextDetectionResult.wrap(buildAwsValue())
}
object TextDetectionResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.TextDetectionResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.TextDetectionResult =
      zio.aws.rekognition.model.TextDetectionResult(
        timestamp.map(value => value),
        textDetection.map(value => value.asEditable)
      )
    def timestamp: Option[Timestamp]
    def textDetection: Option[zio.aws.rekognition.model.TextDetection.ReadOnly]
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getTextDetection
        : ZIO[Any, AwsError, zio.aws.rekognition.model.TextDetection.ReadOnly] =
      AwsError.unwrapOptionField("textDetection", textDetection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.TextDetectionResult
  ) extends zio.aws.rekognition.model.TextDetectionResult.ReadOnly {
    override val timestamp: Option[Timestamp] = scala
      .Option(impl.timestamp())
      .map(value => zio.aws.rekognition.model.primitives.Timestamp(value))
    override val textDetection
        : Option[zio.aws.rekognition.model.TextDetection.ReadOnly] = scala
      .Option(impl.textDetection())
      .map(value => zio.aws.rekognition.model.TextDetection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.TextDetectionResult
  ): zio.aws.rekognition.model.TextDetectionResult.ReadOnly = new Wrapper(impl)
}
