package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.StreamProcessorName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StreamProcessor(
    name: Option[StreamProcessorName] = None,
    status: Option[zio.aws.rekognition.model.StreamProcessorStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StreamProcessor = {
    import StreamProcessor.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StreamProcessor
      .builder()
      .optionallyWith(
        name.map(value => StreamProcessorName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.StreamProcessor.ReadOnly =
    zio.aws.rekognition.model.StreamProcessor.wrap(buildAwsValue())
}
object StreamProcessor {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StreamProcessor
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StreamProcessor =
      zio.aws.rekognition.model
        .StreamProcessor(name.map(value => value), status.map(value => value))
    def name: Option[StreamProcessorName]
    def status: Option[zio.aws.rekognition.model.StreamProcessorStatus]
    def getName: ZIO[Any, AwsError, StreamProcessorName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.rekognition.model.StreamProcessorStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StreamProcessor
  ) extends zio.aws.rekognition.model.StreamProcessor.ReadOnly {
    override val name: Option[StreamProcessorName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.rekognition.model.primitives.StreamProcessorName(value)
      )
    override val status
        : Option[zio.aws.rekognition.model.StreamProcessorStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.rekognition.model.StreamProcessorStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StreamProcessor
  ): zio.aws.rekognition.model.StreamProcessor.ReadOnly = new Wrapper(impl)
}
