package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{JobTag, ClientRequestToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartTextDetectionRequest(
    video: zio.aws.rekognition.model.Video,
    clientRequestToken: Option[ClientRequestToken] = None,
    notificationChannel: Option[zio.aws.rekognition.model.NotificationChannel] =
      None,
    jobTag: Option[JobTag] = None,
    filters: Option[zio.aws.rekognition.model.StartTextDetectionFilters] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StartTextDetectionRequest = {
    import StartTextDetectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StartTextDetectionRequest
      .builder()
      .video(video.buildAwsValue())
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(notificationChannel.map(value => value.buildAwsValue()))(
        _.notificationChannel
      )
      .optionallyWith(
        jobTag.map(value => JobTag.unwrap(value): java.lang.String)
      )(_.jobTag)
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.StartTextDetectionRequest.ReadOnly =
    zio.aws.rekognition.model.StartTextDetectionRequest.wrap(buildAwsValue())
}
object StartTextDetectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StartTextDetectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StartTextDetectionRequest =
      zio.aws.rekognition.model.StartTextDetectionRequest(
        video.asEditable,
        clientRequestToken.map(value => value),
        notificationChannel.map(value => value.asEditable),
        jobTag.map(value => value),
        filters.map(value => value.asEditable)
      )
    def video: zio.aws.rekognition.model.Video.ReadOnly
    def clientRequestToken: Option[ClientRequestToken]
    def notificationChannel
        : Option[zio.aws.rekognition.model.NotificationChannel.ReadOnly]
    def jobTag: Option[JobTag]
    def filters
        : Option[zio.aws.rekognition.model.StartTextDetectionFilters.ReadOnly]
    def getVideo: ZIO[Any, Nothing, zio.aws.rekognition.model.Video.ReadOnly] =
      ZIO.succeed(video)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getNotificationChannel: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.NotificationChannel.ReadOnly
    ] = AwsError.unwrapOptionField("notificationChannel", notificationChannel)
    def getJobTag: ZIO[Any, AwsError, JobTag] =
      AwsError.unwrapOptionField("jobTag", jobTag)
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.StartTextDetectionFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StartTextDetectionRequest
  ) extends zio.aws.rekognition.model.StartTextDetectionRequest.ReadOnly {
    override val video: zio.aws.rekognition.model.Video.ReadOnly =
      zio.aws.rekognition.model.Video.wrap(impl.video())
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.rekognition.model.primitives.ClientRequestToken(value)
      )
    override val notificationChannel
        : Option[zio.aws.rekognition.model.NotificationChannel.ReadOnly] = scala
      .Option(impl.notificationChannel())
      .map(value => zio.aws.rekognition.model.NotificationChannel.wrap(value))
    override val jobTag: Option[JobTag] = scala
      .Option(impl.jobTag())
      .map(value => zio.aws.rekognition.model.primitives.JobTag(value))
    override val filters
        : Option[zio.aws.rekognition.model.StartTextDetectionFilters.ReadOnly] =
      scala
        .Option(impl.filters())
        .map(value =>
          zio.aws.rekognition.model.StartTextDetectionFilters.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StartTextDetectionRequest
  ): zio.aws.rekognition.model.StartTextDetectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
