package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{SegmentConfidence, ULong}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ShotSegment(
    index: Option[ULong] = None,
    confidence: Option[SegmentConfidence] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ShotSegment = {
    import ShotSegment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ShotSegment
      .builder()
      .optionallyWith(index.map(value => ULong.unwrap(value): java.lang.Long))(
        _.index
      )
      .optionallyWith(
        confidence.map(value =>
          SegmentConfidence.unwrap(value): java.lang.Float
        )
      )(_.confidence)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.ShotSegment.ReadOnly =
    zio.aws.rekognition.model.ShotSegment.wrap(buildAwsValue())
}
object ShotSegment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ShotSegment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ShotSegment =
      zio.aws.rekognition.model
        .ShotSegment(index.map(value => value), confidence.map(value => value))
    def index: Option[ULong]
    def confidence: Option[SegmentConfidence]
    def getIndex: ZIO[Any, AwsError, ULong] =
      AwsError.unwrapOptionField("index", index)
    def getConfidence: ZIO[Any, AwsError, SegmentConfidence] =
      AwsError.unwrapOptionField("confidence", confidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ShotSegment
  ) extends zio.aws.rekognition.model.ShotSegment.ReadOnly {
    override val index: Option[ULong] = scala
      .Option(impl.index())
      .map(value => zio.aws.rekognition.model.primitives.ULong(value))
    override val confidence: Option[SegmentConfidence] = scala
      .Option(impl.confidence())
      .map(value =>
        zio.aws.rekognition.model.primitives.SegmentConfidence(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ShotSegment
  ): zio.aws.rekognition.model.ShotSegment.ReadOnly = new Wrapper(impl)
}
