package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RecognizeCelebritiesResponse(
    celebrityFaces: Option[Iterable[zio.aws.rekognition.model.Celebrity]] =
      None,
    unrecognizedFaces: Option[
      Iterable[zio.aws.rekognition.model.ComparedFace]
    ] = None,
    orientationCorrection: Option[
      zio.aws.rekognition.model.OrientationCorrection
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesResponse = {
    import RecognizeCelebritiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesResponse
      .builder()
      .optionallyWith(
        celebrityFaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.celebrityFaces)
      .optionallyWith(
        unrecognizedFaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unrecognizedFaces)
      .optionallyWith(orientationCorrection.map(value => value.unwrap))(
        _.orientationCorrection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.RecognizeCelebritiesResponse.ReadOnly =
    zio.aws.rekognition.model.RecognizeCelebritiesResponse.wrap(buildAwsValue())
}
object RecognizeCelebritiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.RecognizeCelebritiesResponse =
      zio.aws.rekognition.model.RecognizeCelebritiesResponse(
        celebrityFaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unrecognizedFaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        orientationCorrection.map(value => value)
      )
    def celebrityFaces
        : Option[List[zio.aws.rekognition.model.Celebrity.ReadOnly]]
    def unrecognizedFaces
        : Option[List[zio.aws.rekognition.model.ComparedFace.ReadOnly]]
    def orientationCorrection
        : Option[zio.aws.rekognition.model.OrientationCorrection]
    def getCelebrityFaces: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.Celebrity.ReadOnly
    ]] = AwsError.unwrapOptionField("celebrityFaces", celebrityFaces)
    def getUnrecognizedFaces: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.ComparedFace.ReadOnly
    ]] = AwsError.unwrapOptionField("unrecognizedFaces", unrecognizedFaces)
    def getOrientationCorrection
        : ZIO[Any, AwsError, zio.aws.rekognition.model.OrientationCorrection] =
      AwsError.unwrapOptionField("orientationCorrection", orientationCorrection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesResponse
  ) extends zio.aws.rekognition.model.RecognizeCelebritiesResponse.ReadOnly {
    override val celebrityFaces
        : Option[List[zio.aws.rekognition.model.Celebrity.ReadOnly]] = scala
      .Option(impl.celebrityFaces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.Celebrity.wrap(item)
        }.toList
      )
    override val unrecognizedFaces
        : Option[List[zio.aws.rekognition.model.ComparedFace.ReadOnly]] = scala
      .Option(impl.unrecognizedFaces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.ComparedFace.wrap(item)
        }.toList
      )
    override val orientationCorrection
        : Option[zio.aws.rekognition.model.OrientationCorrection] = scala
      .Option(impl.orientationCorrection())
      .map(value => zio.aws.rekognition.model.OrientationCorrection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesResponse
  ): zio.aws.rekognition.model.RecognizeCelebritiesResponse.ReadOnly =
    new Wrapper(impl)
}
