package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait ProjectVersionStatus {
  def unwrap
      : software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus
}
object ProjectVersionStatus {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus
  ): zio.aws.rekognition.model.ProjectVersionStatus = value match {
    case software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus.TRAINING_IN_PROGRESS =>
      val r = TRAINING_IN_PROGRESS
      r
    case software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus.TRAINING_COMPLETED =>
      val r = TRAINING_COMPLETED
      r
    case software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus.TRAINING_FAILED =>
      val r = TRAINING_FAILED
      r
    case software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus.STOPPED =>
      val r = STOPPED
      r
    case software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus.DELETING =>
      val r = DELETING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rekognition.model.ProjectVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus =
      software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object TRAINING_IN_PROGRESS
      extends zio.aws.rekognition.model.ProjectVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus =
      software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus.TRAINING_IN_PROGRESS
  }
  case object TRAINING_COMPLETED
      extends zio.aws.rekognition.model.ProjectVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus =
      software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus.TRAINING_COMPLETED
  }
  case object TRAINING_FAILED
      extends zio.aws.rekognition.model.ProjectVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus =
      software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus.TRAINING_FAILED
  }
  case object STARTING extends zio.aws.rekognition.model.ProjectVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus =
      software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus.STARTING
  }
  case object RUNNING extends zio.aws.rekognition.model.ProjectVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus =
      software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus.RUNNING
  }
  case object FAILED extends zio.aws.rekognition.model.ProjectVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus =
      software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus.FAILED
  }
  case object STOPPING extends zio.aws.rekognition.model.ProjectVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus =
      software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus.STOPPING
  }
  case object STOPPED extends zio.aws.rekognition.model.ProjectVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus =
      software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus.STOPPED
  }
  case object DELETING extends zio.aws.rekognition.model.ProjectVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus =
      software.amazon.awssdk.services.rekognition.model.ProjectVersionStatus.DELETING
  }
}
