package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Point(x: Option[Float] = None, y: Option[Float] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.Point = {
    import Point.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.Point
      .builder()
      .optionallyWith(x.map(value => value: java.lang.Float))(_.x)
      .optionallyWith(y.map(value => value: java.lang.Float))(_.y)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.Point.ReadOnly =
    zio.aws.rekognition.model.Point.wrap(buildAwsValue())
}
object Point {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rekognition.model.Point] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.Point = zio.aws.rekognition.model
      .Point(x.map(value => value), y.map(value => value))
    def x: Option[Float]
    def y: Option[Float]
    def getX: ZIO[Any, AwsError, Float] = AwsError.unwrapOptionField("x", x)
    def getY: ZIO[Any, AwsError, Float] = AwsError.unwrapOptionField("y", y)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.Point
  ) extends zio.aws.rekognition.model.Point.ReadOnly {
    override val x: Option[Float] =
      scala.Option(impl.x()).map(value => value: Float)
    override val y: Option[Float] =
      scala.Option(impl.y()).map(value => value: Float)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.Point
  ): zio.aws.rekognition.model.Point.ReadOnly = new Wrapper(impl)
}
