package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Percent
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModerationLabel(
    confidence: Option[Percent] = None,
    name: Option[String] = None,
    parentName: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ModerationLabel = {
    import ModerationLabel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ModerationLabel
      .builder()
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(parentName.map(value => value: java.lang.String))(
        _.parentName
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.ModerationLabel.ReadOnly =
    zio.aws.rekognition.model.ModerationLabel.wrap(buildAwsValue())
}
object ModerationLabel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ModerationLabel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ModerationLabel =
      zio.aws.rekognition.model.ModerationLabel(
        confidence.map(value => value),
        name.map(value => value),
        parentName.map(value => value)
      )
    def confidence: Option[Percent]
    def name: Option[String]
    def parentName: Option[String]
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getParentName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parentName", parentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ModerationLabel
  ) extends zio.aws.rekognition.model.ModerationLabel.ReadOnly {
    override val confidence: Option[Percent] = scala
      .Option(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val parentName: Option[String] =
      scala.Option(impl.parentName()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ModerationLabel
  ): zio.aws.rekognition.model.ModerationLabel.ReadOnly = new Wrapper(impl)
}
