package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.ExtendedPaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDatasetLabelsResponse(
    datasetLabelDescriptions: Option[
      Iterable[zio.aws.rekognition.model.DatasetLabelDescription]
    ] = None,
    nextToken: Option[ExtendedPaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ListDatasetLabelsResponse = {
    import ListDatasetLabelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ListDatasetLabelsResponse
      .builder()
      .optionallyWith(
        datasetLabelDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.datasetLabelDescriptions)
      .optionallyWith(
        nextToken.map(value =>
          ExtendedPaginationToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.ListDatasetLabelsResponse.ReadOnly =
    zio.aws.rekognition.model.ListDatasetLabelsResponse.wrap(buildAwsValue())
}
object ListDatasetLabelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ListDatasetLabelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ListDatasetLabelsResponse =
      zio.aws.rekognition.model.ListDatasetLabelsResponse(
        datasetLabelDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def datasetLabelDescriptions: Option[
      List[zio.aws.rekognition.model.DatasetLabelDescription.ReadOnly]
    ]
    def nextToken: Option[ExtendedPaginationToken]
    def getDatasetLabelDescriptions: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.DatasetLabelDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "datasetLabelDescriptions",
      datasetLabelDescriptions
    )
    def getNextToken: ZIO[Any, AwsError, ExtendedPaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ListDatasetLabelsResponse
  ) extends zio.aws.rekognition.model.ListDatasetLabelsResponse.ReadOnly {
    override val datasetLabelDescriptions: Option[
      List[zio.aws.rekognition.model.DatasetLabelDescription.ReadOnly]
    ] = scala
      .Option(impl.datasetLabelDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.DatasetLabelDescription.wrap(item)
        }.toList
      )
    override val nextToken: Option[ExtendedPaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.rekognition.model.primitives.ExtendedPaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ListDatasetLabelsResponse
  ): zio.aws.rekognition.model.ListDatasetLabelsResponse.ReadOnly = new Wrapper(
    impl
  )
}
