package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.ImageBlob
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Image(
    bytes: Option[ImageBlob] = None,
    s3Object: Option[zio.aws.rekognition.model.S3Object] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.Image = {
    import Image.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.Image
      .builder()
      .optionallyWith(
        bytes.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.bytes)
      .optionallyWith(s3Object.map(value => value.buildAwsValue()))(_.s3Object)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.Image.ReadOnly =
    zio.aws.rekognition.model.Image.wrap(buildAwsValue())
}
object Image {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rekognition.model.Image] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.Image = zio.aws.rekognition.model
      .Image(bytes.map(value => value), s3Object.map(value => value.asEditable))
    def bytes: Option[ImageBlob]
    def s3Object: Option[zio.aws.rekognition.model.S3Object.ReadOnly]
    def getBytes: ZIO[Any, AwsError, ImageBlob] =
      AwsError.unwrapOptionField("bytes", bytes)
    def getS3Object
        : ZIO[Any, AwsError, zio.aws.rekognition.model.S3Object.ReadOnly] =
      AwsError.unwrapOptionField("s3Object", s3Object)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.Image
  ) extends zio.aws.rekognition.model.Image.ReadOnly {
    override val bytes: Option[ImageBlob] = scala
      .Option(impl.bytes())
      .map(value =>
        zio.aws.rekognition.model.primitives
          .ImageBlob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val s3Object: Option[zio.aws.rekognition.model.S3Object.ReadOnly] =
      scala
        .Option(impl.s3Object())
        .map(value => zio.aws.rekognition.model.S3Object.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.Image
  ): zio.aws.rekognition.model.Image.ReadOnly = new Wrapper(impl)
}
