package zio.aws.rekognition.model
import java.lang.Integer
import zio.aws.rekognition.model.primitives.{PaginationToken, MaxResults, JobId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetFaceDetectionRequest(
    jobId: JobId,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.GetFaceDetectionRequest = {
    import GetFaceDetectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.GetFaceDetectionRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.GetFaceDetectionRequest.ReadOnly =
    zio.aws.rekognition.model.GetFaceDetectionRequest.wrap(buildAwsValue())
}
object GetFaceDetectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.GetFaceDetectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.GetFaceDetectionRequest =
      zio.aws.rekognition.model.GetFaceDetectionRequest(
        jobId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def jobId: JobId
    def maxResults: Option[MaxResults]
    def nextToken: Option[PaginationToken]
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.GetFaceDetectionRequest
  ) extends zio.aws.rekognition.model.GetFaceDetectionRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.rekognition.model.primitives.JobId(impl.jobId())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.rekognition.model.primitives.MaxResults(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.rekognition.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.GetFaceDetectionRequest
  ): zio.aws.rekognition.model.GetFaceDetectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
