package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DistributeDatasetEntriesRequest(
    datasets: Iterable[zio.aws.rekognition.model.DistributeDataset]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DistributeDatasetEntriesRequest = {
    import DistributeDatasetEntriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DistributeDatasetEntriesRequest
      .builder()
      .datasets(datasets.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.DistributeDatasetEntriesRequest.ReadOnly =
    zio.aws.rekognition.model.DistributeDatasetEntriesRequest
      .wrap(buildAwsValue())
}
object DistributeDatasetEntriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DistributeDatasetEntriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DistributeDatasetEntriesRequest =
      zio.aws.rekognition.model.DistributeDatasetEntriesRequest(datasets.map {
        item =>
          item.asEditable
      })
    def datasets: List[zio.aws.rekognition.model.DistributeDataset.ReadOnly]
    def getDatasets: ZIO[Any, Nothing, List[
      zio.aws.rekognition.model.DistributeDataset.ReadOnly
    ]] = ZIO.succeed(datasets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DistributeDatasetEntriesRequest
  ) extends zio.aws.rekognition.model.DistributeDatasetEntriesRequest.ReadOnly {
    override val datasets
        : List[zio.aws.rekognition.model.DistributeDataset.ReadOnly] = impl
      .datasets()
      .asScala
      .map { item =>
        zio.aws.rekognition.model.DistributeDataset.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DistributeDatasetEntriesRequest
  ): zio.aws.rekognition.model.DistributeDatasetEntriesRequest.ReadOnly =
    new Wrapper(impl)
}
