package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DetectCustomLabelsResponse(
    customLabels: Option[Iterable[zio.aws.rekognition.model.CustomLabel]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DetectCustomLabelsResponse = {
    import DetectCustomLabelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DetectCustomLabelsResponse
      .builder()
      .optionallyWith(
        customLabels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customLabels)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.DetectCustomLabelsResponse.ReadOnly =
    zio.aws.rekognition.model.DetectCustomLabelsResponse.wrap(buildAwsValue())
}
object DetectCustomLabelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DetectCustomLabelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DetectCustomLabelsResponse =
      zio.aws.rekognition.model.DetectCustomLabelsResponse(
        customLabels.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def customLabels
        : Option[List[zio.aws.rekognition.model.CustomLabel.ReadOnly]]
    def getCustomLabels: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.CustomLabel.ReadOnly
    ]] = AwsError.unwrapOptionField("customLabels", customLabels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DetectCustomLabelsResponse
  ) extends zio.aws.rekognition.model.DetectCustomLabelsResponse.ReadOnly {
    override val customLabels
        : Option[List[zio.aws.rekognition.model.CustomLabel.ReadOnly]] = scala
      .Option(impl.customLabels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.CustomLabel.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DetectCustomLabelsResponse
  ): zio.aws.rekognition.model.DetectCustomLabelsResponse.ReadOnly =
    new Wrapper(impl)
}
