package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.ExtendedPaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeProjectVersionsResponse(
    projectVersionDescriptions: Option[
      Iterable[zio.aws.rekognition.model.ProjectVersionDescription]
    ] = None,
    nextToken: Option[ExtendedPaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DescribeProjectVersionsResponse = {
    import DescribeProjectVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DescribeProjectVersionsResponse
      .builder()
      .optionallyWith(
        projectVersionDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.projectVersionDescriptions)
      .optionallyWith(
        nextToken.map(value =>
          ExtendedPaginationToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.DescribeProjectVersionsResponse.ReadOnly =
    zio.aws.rekognition.model.DescribeProjectVersionsResponse
      .wrap(buildAwsValue())
}
object DescribeProjectVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DescribeProjectVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DescribeProjectVersionsResponse =
      zio.aws.rekognition.model.DescribeProjectVersionsResponse(
        projectVersionDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def projectVersionDescriptions: Option[
      List[zio.aws.rekognition.model.ProjectVersionDescription.ReadOnly]
    ]
    def nextToken: Option[ExtendedPaginationToken]
    def getProjectVersionDescriptions: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.ProjectVersionDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "projectVersionDescriptions",
      projectVersionDescriptions
    )
    def getNextToken: ZIO[Any, AwsError, ExtendedPaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DescribeProjectVersionsResponse
  ) extends zio.aws.rekognition.model.DescribeProjectVersionsResponse.ReadOnly {
    override val projectVersionDescriptions: Option[
      List[zio.aws.rekognition.model.ProjectVersionDescription.ReadOnly]
    ] = scala
      .Option(impl.projectVersionDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.ProjectVersionDescription.wrap(item)
        }.toList
      )
    override val nextToken: Option[ExtendedPaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.rekognition.model.primitives.ExtendedPaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DescribeProjectVersionsResponse
  ): zio.aws.rekognition.model.DescribeProjectVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
