package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeDatasetResponse(
    datasetDescription: Option[zio.aws.rekognition.model.DatasetDescription] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DescribeDatasetResponse = {
    import DescribeDatasetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DescribeDatasetResponse
      .builder()
      .optionallyWith(datasetDescription.map(value => value.buildAwsValue()))(
        _.datasetDescription
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DescribeDatasetResponse.ReadOnly =
    zio.aws.rekognition.model.DescribeDatasetResponse.wrap(buildAwsValue())
}
object DescribeDatasetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DescribeDatasetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DescribeDatasetResponse =
      zio.aws.rekognition.model.DescribeDatasetResponse(
        datasetDescription.map(value => value.asEditable)
      )
    def datasetDescription
        : Option[zio.aws.rekognition.model.DatasetDescription.ReadOnly]
    def getDatasetDescription: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.DatasetDescription.ReadOnly
    ] = AwsError.unwrapOptionField("datasetDescription", datasetDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DescribeDatasetResponse
  ) extends zio.aws.rekognition.model.DescribeDatasetResponse.ReadOnly {
    override val datasetDescription
        : Option[zio.aws.rekognition.model.DatasetDescription.ReadOnly] = scala
      .Option(impl.datasetDescription())
      .map(value => zio.aws.rekognition.model.DatasetDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DescribeDatasetResponse
  ): zio.aws.rekognition.model.DescribeDatasetResponse.ReadOnly = new Wrapper(
    impl
  )
}
