package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.FaceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteFacesResponse(
    deletedFaces: Option[Iterable[FaceId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DeleteFacesResponse = {
    import DeleteFacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DeleteFacesResponse
      .builder()
      .optionallyWith(
        deletedFaces.map(value =>
          value.map { item =>
            FaceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.deletedFaces)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DeleteFacesResponse.ReadOnly =
    zio.aws.rekognition.model.DeleteFacesResponse.wrap(buildAwsValue())
}
object DeleteFacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DeleteFacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DeleteFacesResponse =
      zio.aws.rekognition.model
        .DeleteFacesResponse(deletedFaces.map(value => value))
    def deletedFaces: Option[List[FaceId]]
    def getDeletedFaces: ZIO[Any, AwsError, List[FaceId]] =
      AwsError.unwrapOptionField("deletedFaces", deletedFaces)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DeleteFacesResponse
  ) extends zio.aws.rekognition.model.DeleteFacesResponse.ReadOnly {
    override val deletedFaces: Option[List[FaceId]] = scala
      .Option(impl.deletedFaces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.primitives.FaceId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DeleteFacesResponse
  ): zio.aws.rekognition.model.DeleteFacesResponse.ReadOnly = new Wrapper(impl)
}
