package zio.aws.rekognition.model
import java.lang.Integer
import zio.aws.rekognition.model.primitives.UInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DatasetLabelStats(
    entryCount: Option[UInteger] = None,
    boundingBoxCount: Option[UInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DatasetLabelStats = {
    import DatasetLabelStats.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DatasetLabelStats
      .builder()
      .optionallyWith(entryCount.map(value => UInteger.unwrap(value): Integer))(
        _.entryCount
      )
      .optionallyWith(
        boundingBoxCount.map(value => UInteger.unwrap(value): Integer)
      )(_.boundingBoxCount)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DatasetLabelStats.ReadOnly =
    zio.aws.rekognition.model.DatasetLabelStats.wrap(buildAwsValue())
}
object DatasetLabelStats {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DatasetLabelStats
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DatasetLabelStats =
      zio.aws.rekognition.model.DatasetLabelStats(
        entryCount.map(value => value),
        boundingBoxCount.map(value => value)
      )
    def entryCount: Option[UInteger]
    def boundingBoxCount: Option[UInteger]
    def getEntryCount: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("entryCount", entryCount)
    def getBoundingBoxCount: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("boundingBoxCount", boundingBoxCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DatasetLabelStats
  ) extends zio.aws.rekognition.model.DatasetLabelStats.ReadOnly {
    override val entryCount: Option[UInteger] = scala
      .Option(impl.entryCount())
      .map(value => zio.aws.rekognition.model.primitives.UInteger(value))
    override val boundingBoxCount: Option[UInteger] = scala
      .Option(impl.boundingBoxCount())
      .map(value => zio.aws.rekognition.model.primitives.UInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DatasetLabelStats
  ): zio.aws.rekognition.model.DatasetLabelStats.ReadOnly = new Wrapper(impl)
}
