package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.ULong
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AudioMetadata(
    codec: Option[String] = None,
    durationMillis: Option[ULong] = None,
    sampleRate: Option[ULong] = None,
    numberOfChannels: Option[ULong] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.AudioMetadata = {
    import AudioMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.AudioMetadata
      .builder()
      .optionallyWith(codec.map(value => value: java.lang.String))(_.codec)
      .optionallyWith(
        durationMillis.map(value => ULong.unwrap(value): java.lang.Long)
      )(_.durationMillis)
      .optionallyWith(
        sampleRate.map(value => ULong.unwrap(value): java.lang.Long)
      )(_.sampleRate)
      .optionallyWith(
        numberOfChannels.map(value => ULong.unwrap(value): java.lang.Long)
      )(_.numberOfChannels)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.AudioMetadata.ReadOnly =
    zio.aws.rekognition.model.AudioMetadata.wrap(buildAwsValue())
}
object AudioMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.AudioMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.AudioMetadata =
      zio.aws.rekognition.model.AudioMetadata(
        codec.map(value => value),
        durationMillis.map(value => value),
        sampleRate.map(value => value),
        numberOfChannels.map(value => value)
      )
    def codec: Option[String]
    def durationMillis: Option[ULong]
    def sampleRate: Option[ULong]
    def numberOfChannels: Option[ULong]
    def getCodec: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("codec", codec)
    def getDurationMillis: ZIO[Any, AwsError, ULong] =
      AwsError.unwrapOptionField("durationMillis", durationMillis)
    def getSampleRate: ZIO[Any, AwsError, ULong] =
      AwsError.unwrapOptionField("sampleRate", sampleRate)
    def getNumberOfChannels: ZIO[Any, AwsError, ULong] =
      AwsError.unwrapOptionField("numberOfChannels", numberOfChannels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.AudioMetadata
  ) extends zio.aws.rekognition.model.AudioMetadata.ReadOnly {
    override val codec: Option[String] =
      scala.Option(impl.codec()).map(value => value: String)
    override val durationMillis: Option[ULong] = scala
      .Option(impl.durationMillis())
      .map(value => zio.aws.rekognition.model.primitives.ULong(value))
    override val sampleRate: Option[ULong] = scala
      .Option(impl.sampleRate())
      .map(value => zio.aws.rekognition.model.primitives.ULong(value))
    override val numberOfChannels: Option[ULong] = scala
      .Option(impl.numberOfChannels())
      .map(value => zio.aws.rekognition.model.primitives.ULong(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.AudioMetadata
  ): zio.aws.rekognition.model.AudioMetadata.ReadOnly = new Wrapper(impl)
}
