package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.ULong
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VideoMetadata(
    codec: Option[String] = None,
    durationMillis: Option[ULong] = None,
    format: Option[String] = None,
    frameRate: Option[Float] = None,
    frameHeight: Option[ULong] = None,
    frameWidth: Option[ULong] = None,
    colorRange: Option[zio.aws.rekognition.model.VideoColorRange] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.VideoMetadata = {
    import VideoMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.VideoMetadata
      .builder()
      .optionallyWith(codec.map(value => value: java.lang.String))(_.codec)
      .optionallyWith(
        durationMillis.map(value => ULong.unwrap(value): java.lang.Long)
      )(_.durationMillis)
      .optionallyWith(format.map(value => value: java.lang.String))(_.format)
      .optionallyWith(frameRate.map(value => value: java.lang.Float))(
        _.frameRate
      )
      .optionallyWith(
        frameHeight.map(value => ULong.unwrap(value): java.lang.Long)
      )(_.frameHeight)
      .optionallyWith(
        frameWidth.map(value => ULong.unwrap(value): java.lang.Long)
      )(_.frameWidth)
      .optionallyWith(colorRange.map(value => value.unwrap))(_.colorRange)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.VideoMetadata.ReadOnly =
    zio.aws.rekognition.model.VideoMetadata.wrap(buildAwsValue())
}
object VideoMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.VideoMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.VideoMetadata =
      zio.aws.rekognition.model.VideoMetadata(
        codec.map(value => value),
        durationMillis.map(value => value),
        format.map(value => value),
        frameRate.map(value => value),
        frameHeight.map(value => value),
        frameWidth.map(value => value),
        colorRange.map(value => value)
      )
    def codec: Option[String]
    def durationMillis: Option[ULong]
    def format: Option[String]
    def frameRate: Option[Float]
    def frameHeight: Option[ULong]
    def frameWidth: Option[ULong]
    def colorRange: Option[zio.aws.rekognition.model.VideoColorRange]
    def getCodec: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("codec", codec)
    def getDurationMillis: ZIO[Any, AwsError, ULong] =
      AwsError.unwrapOptionField("durationMillis", durationMillis)
    def getFormat: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("format", format)
    def getFrameRate: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("frameRate", frameRate)
    def getFrameHeight: ZIO[Any, AwsError, ULong] =
      AwsError.unwrapOptionField("frameHeight", frameHeight)
    def getFrameWidth: ZIO[Any, AwsError, ULong] =
      AwsError.unwrapOptionField("frameWidth", frameWidth)
    def getColorRange
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoColorRange] =
      AwsError.unwrapOptionField("colorRange", colorRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.VideoMetadata
  ) extends zio.aws.rekognition.model.VideoMetadata.ReadOnly {
    override val codec: Option[String] =
      scala.Option(impl.codec()).map(value => value: String)
    override val durationMillis: Option[ULong] = scala
      .Option(impl.durationMillis())
      .map(value => zio.aws.rekognition.model.primitives.ULong(value))
    override val format: Option[String] =
      scala.Option(impl.format()).map(value => value: String)
    override val frameRate: Option[Float] =
      scala.Option(impl.frameRate()).map(value => value: Float)
    override val frameHeight: Option[ULong] = scala
      .Option(impl.frameHeight())
      .map(value => zio.aws.rekognition.model.primitives.ULong(value))
    override val frameWidth: Option[ULong] = scala
      .Option(impl.frameWidth())
      .map(value => zio.aws.rekognition.model.primitives.ULong(value))
    override val colorRange: Option[zio.aws.rekognition.model.VideoColorRange] =
      scala
        .Option(impl.colorRange())
        .map(value => zio.aws.rekognition.model.VideoColorRange.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.VideoMetadata
  ): zio.aws.rekognition.model.VideoMetadata.ReadOnly = new Wrapper(impl)
}
