package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait TextTypes {
  def unwrap: software.amazon.awssdk.services.rekognition.model.TextTypes
}
object TextTypes {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.TextTypes
  ): zio.aws.rekognition.model.TextTypes = value match {
    case software.amazon.awssdk.services.rekognition.model.TextTypes.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rekognition.model.TextTypes.LINE =>
      val r = LINE
      r
    case software.amazon.awssdk.services.rekognition.model.TextTypes.WORD =>
      val r = WORD
      r
  }
  case object unknownToSdkVersion extends zio.aws.rekognition.model.TextTypes {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.TextTypes =
      software.amazon.awssdk.services.rekognition.model.TextTypes.UNKNOWN_TO_SDK_VERSION
  }
  case object LINE extends zio.aws.rekognition.model.TextTypes {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.TextTypes =
      software.amazon.awssdk.services.rekognition.model.TextTypes.LINE
  }
  case object WORD extends zio.aws.rekognition.model.TextTypes {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.TextTypes =
      software.amazon.awssdk.services.rekognition.model.TextTypes.WORD
  }
}
