package zio.aws.rekognition.model
import java.lang.Integer
import zio.aws.rekognition.model.primitives.{Percent, UInteger}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TextDetection(
    detectedText: Option[String] = None,
    `type`: Option[zio.aws.rekognition.model.TextTypes] = None,
    id: Option[UInteger] = None,
    parentId: Option[UInteger] = None,
    confidence: Option[Percent] = None,
    geometry: Option[zio.aws.rekognition.model.Geometry] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.TextDetection = {
    import TextDetection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.TextDetection
      .builder()
      .optionallyWith(detectedText.map(value => value: java.lang.String))(
        _.detectedText
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(id.map(value => UInteger.unwrap(value): Integer))(_.id)
      .optionallyWith(parentId.map(value => UInteger.unwrap(value): Integer))(
        _.parentId
      )
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .optionallyWith(geometry.map(value => value.buildAwsValue()))(_.geometry)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.TextDetection.ReadOnly =
    zio.aws.rekognition.model.TextDetection.wrap(buildAwsValue())
}
object TextDetection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.TextDetection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.TextDetection =
      zio.aws.rekognition.model.TextDetection(
        detectedText.map(value => value),
        `type`.map(value => value),
        id.map(value => value),
        parentId.map(value => value),
        confidence.map(value => value),
        geometry.map(value => value.asEditable)
      )
    def detectedText: Option[String]
    def `type`: Option[zio.aws.rekognition.model.TextTypes]
    def id: Option[UInteger]
    def parentId: Option[UInteger]
    def confidence: Option[Percent]
    def geometry: Option[zio.aws.rekognition.model.Geometry.ReadOnly]
    def getDetectedText: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("detectedText", detectedText)
    def getType: ZIO[Any, AwsError, zio.aws.rekognition.model.TextTypes] =
      AwsError.unwrapOptionField("type", `type`)
    def getId: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("id", id)
    def getParentId: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("parentId", parentId)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getGeometry
        : ZIO[Any, AwsError, zio.aws.rekognition.model.Geometry.ReadOnly] =
      AwsError.unwrapOptionField("geometry", geometry)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.TextDetection
  ) extends zio.aws.rekognition.model.TextDetection.ReadOnly {
    override val detectedText: Option[String] =
      scala.Option(impl.detectedText()).map(value => value: String)
    override val `type`: Option[zio.aws.rekognition.model.TextTypes] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.rekognition.model.TextTypes.wrap(value))
    override val id: Option[UInteger] = scala
      .Option(impl.id())
      .map(value => zio.aws.rekognition.model.primitives.UInteger(value))
    override val parentId: Option[UInteger] = scala
      .Option(impl.parentId())
      .map(value => zio.aws.rekognition.model.primitives.UInteger(value))
    override val confidence: Option[Percent] = scala
      .Option(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val geometry: Option[zio.aws.rekognition.model.Geometry.ReadOnly] =
      scala
        .Option(impl.geometry())
        .map(value => zio.aws.rekognition.model.Geometry.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.TextDetection
  ): zio.aws.rekognition.model.TextDetection.ReadOnly = new Wrapper(impl)
}
