package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{JobTag, ClientRequestToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartSegmentDetectionRequest(
    video: zio.aws.rekognition.model.Video,
    clientRequestToken: Option[ClientRequestToken] = None,
    notificationChannel: Option[zio.aws.rekognition.model.NotificationChannel] =
      None,
    jobTag: Option[JobTag] = None,
    filters: Option[zio.aws.rekognition.model.StartSegmentDetectionFilters] =
      None,
    segmentTypes: Iterable[zio.aws.rekognition.model.SegmentType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StartSegmentDetectionRequest = {
    import StartSegmentDetectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StartSegmentDetectionRequest
      .builder()
      .video(video.buildAwsValue())
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(notificationChannel.map(value => value.buildAwsValue()))(
        _.notificationChannel
      )
      .optionallyWith(
        jobTag.map(value => JobTag.unwrap(value): java.lang.String)
      )(_.jobTag)
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .segmentTypesWithStrings(segmentTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.StartSegmentDetectionRequest.ReadOnly =
    zio.aws.rekognition.model.StartSegmentDetectionRequest.wrap(buildAwsValue())
}
object StartSegmentDetectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StartSegmentDetectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StartSegmentDetectionRequest =
      zio.aws.rekognition.model.StartSegmentDetectionRequest(
        video.asEditable,
        clientRequestToken.map(value => value),
        notificationChannel.map(value => value.asEditable),
        jobTag.map(value => value),
        filters.map(value => value.asEditable),
        segmentTypes
      )
    def video: zio.aws.rekognition.model.Video.ReadOnly
    def clientRequestToken: Option[ClientRequestToken]
    def notificationChannel
        : Option[zio.aws.rekognition.model.NotificationChannel.ReadOnly]
    def jobTag: Option[JobTag]
    def filters: Option[
      zio.aws.rekognition.model.StartSegmentDetectionFilters.ReadOnly
    ]
    def segmentTypes: List[zio.aws.rekognition.model.SegmentType]
    def getVideo: ZIO[Any, Nothing, zio.aws.rekognition.model.Video.ReadOnly] =
      ZIO.succeed(video)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getNotificationChannel: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.NotificationChannel.ReadOnly
    ] = AwsError.unwrapOptionField("notificationChannel", notificationChannel)
    def getJobTag: ZIO[Any, AwsError, JobTag] =
      AwsError.unwrapOptionField("jobTag", jobTag)
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.StartSegmentDetectionFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
    def getSegmentTypes
        : ZIO[Any, Nothing, List[zio.aws.rekognition.model.SegmentType]] =
      ZIO.succeed(segmentTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StartSegmentDetectionRequest
  ) extends zio.aws.rekognition.model.StartSegmentDetectionRequest.ReadOnly {
    override val video: zio.aws.rekognition.model.Video.ReadOnly =
      zio.aws.rekognition.model.Video.wrap(impl.video())
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.rekognition.model.primitives.ClientRequestToken(value)
      )
    override val notificationChannel
        : Option[zio.aws.rekognition.model.NotificationChannel.ReadOnly] = scala
      .Option(impl.notificationChannel())
      .map(value => zio.aws.rekognition.model.NotificationChannel.wrap(value))
    override val jobTag: Option[JobTag] = scala
      .Option(impl.jobTag())
      .map(value => zio.aws.rekognition.model.primitives.JobTag(value))
    override val filters: Option[
      zio.aws.rekognition.model.StartSegmentDetectionFilters.ReadOnly
    ] = scala
      .Option(impl.filters())
      .map(value =>
        zio.aws.rekognition.model.StartSegmentDetectionFilters.wrap(value)
      )
    override val segmentTypes: List[zio.aws.rekognition.model.SegmentType] =
      impl
        .segmentTypes()
        .asScala
        .map { item =>
          zio.aws.rekognition.model.SegmentType.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StartSegmentDetectionRequest
  ): zio.aws.rekognition.model.StartSegmentDetectionRequest.ReadOnly =
    new Wrapper(impl)
}
