package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  JobTag,
  Percent,
  ClientRequestToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartLabelDetectionRequest(
    video: zio.aws.rekognition.model.Video,
    clientRequestToken: Option[ClientRequestToken] = None,
    minConfidence: Option[Percent] = None,
    notificationChannel: Option[zio.aws.rekognition.model.NotificationChannel] =
      None,
    jobTag: Option[JobTag] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StartLabelDetectionRequest = {
    import StartLabelDetectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StartLabelDetectionRequest
      .builder()
      .video(video.buildAwsValue())
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        minConfidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.minConfidence)
      .optionallyWith(notificationChannel.map(value => value.buildAwsValue()))(
        _.notificationChannel
      )
      .optionallyWith(
        jobTag.map(value => JobTag.unwrap(value): java.lang.String)
      )(_.jobTag)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.StartLabelDetectionRequest.ReadOnly =
    zio.aws.rekognition.model.StartLabelDetectionRequest.wrap(buildAwsValue())
}
object StartLabelDetectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StartLabelDetectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StartLabelDetectionRequest =
      zio.aws.rekognition.model.StartLabelDetectionRequest(
        video.asEditable,
        clientRequestToken.map(value => value),
        minConfidence.map(value => value),
        notificationChannel.map(value => value.asEditable),
        jobTag.map(value => value)
      )
    def video: zio.aws.rekognition.model.Video.ReadOnly
    def clientRequestToken: Option[ClientRequestToken]
    def minConfidence: Option[Percent]
    def notificationChannel
        : Option[zio.aws.rekognition.model.NotificationChannel.ReadOnly]
    def jobTag: Option[JobTag]
    def getVideo: ZIO[Any, Nothing, zio.aws.rekognition.model.Video.ReadOnly] =
      ZIO.succeed(video)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getMinConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("minConfidence", minConfidence)
    def getNotificationChannel: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.NotificationChannel.ReadOnly
    ] = AwsError.unwrapOptionField("notificationChannel", notificationChannel)
    def getJobTag: ZIO[Any, AwsError, JobTag] =
      AwsError.unwrapOptionField("jobTag", jobTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StartLabelDetectionRequest
  ) extends zio.aws.rekognition.model.StartLabelDetectionRequest.ReadOnly {
    override val video: zio.aws.rekognition.model.Video.ReadOnly =
      zio.aws.rekognition.model.Video.wrap(impl.video())
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.rekognition.model.primitives.ClientRequestToken(value)
      )
    override val minConfidence: Option[Percent] = scala
      .Option(impl.minConfidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val notificationChannel
        : Option[zio.aws.rekognition.model.NotificationChannel.ReadOnly] = scala
      .Option(impl.notificationChannel())
      .map(value => zio.aws.rekognition.model.NotificationChannel.wrap(value))
    override val jobTag: Option[JobTag] = scala
      .Option(impl.jobTag())
      .map(value => zio.aws.rekognition.model.primitives.JobTag(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StartLabelDetectionRequest
  ): zio.aws.rekognition.model.StartLabelDetectionRequest.ReadOnly =
    new Wrapper(impl)
}
