package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  JobTag,
  CollectionId,
  Percent,
  ClientRequestToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartFaceSearchRequest(
    video: zio.aws.rekognition.model.Video,
    clientRequestToken: Option[ClientRequestToken] = None,
    faceMatchThreshold: Option[Percent] = None,
    collectionId: CollectionId,
    notificationChannel: Option[zio.aws.rekognition.model.NotificationChannel] =
      None,
    jobTag: Option[JobTag] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StartFaceSearchRequest = {
    import StartFaceSearchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StartFaceSearchRequest
      .builder()
      .video(video.buildAwsValue())
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        faceMatchThreshold.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.faceMatchThreshold)
      .collectionId(CollectionId.unwrap(collectionId): java.lang.String)
      .optionallyWith(notificationChannel.map(value => value.buildAwsValue()))(
        _.notificationChannel
      )
      .optionallyWith(
        jobTag.map(value => JobTag.unwrap(value): java.lang.String)
      )(_.jobTag)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.StartFaceSearchRequest.ReadOnly =
    zio.aws.rekognition.model.StartFaceSearchRequest.wrap(buildAwsValue())
}
object StartFaceSearchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StartFaceSearchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StartFaceSearchRequest =
      zio.aws.rekognition.model.StartFaceSearchRequest(
        video.asEditable,
        clientRequestToken.map(value => value),
        faceMatchThreshold.map(value => value),
        collectionId,
        notificationChannel.map(value => value.asEditable),
        jobTag.map(value => value)
      )
    def video: zio.aws.rekognition.model.Video.ReadOnly
    def clientRequestToken: Option[ClientRequestToken]
    def faceMatchThreshold: Option[Percent]
    def collectionId: CollectionId
    def notificationChannel
        : Option[zio.aws.rekognition.model.NotificationChannel.ReadOnly]
    def jobTag: Option[JobTag]
    def getVideo: ZIO[Any, Nothing, zio.aws.rekognition.model.Video.ReadOnly] =
      ZIO.succeed(video)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getFaceMatchThreshold: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("faceMatchThreshold", faceMatchThreshold)
    def getCollectionId: ZIO[Any, Nothing, CollectionId] =
      ZIO.succeed(collectionId)
    def getNotificationChannel: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.NotificationChannel.ReadOnly
    ] = AwsError.unwrapOptionField("notificationChannel", notificationChannel)
    def getJobTag: ZIO[Any, AwsError, JobTag] =
      AwsError.unwrapOptionField("jobTag", jobTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StartFaceSearchRequest
  ) extends zio.aws.rekognition.model.StartFaceSearchRequest.ReadOnly {
    override val video: zio.aws.rekognition.model.Video.ReadOnly =
      zio.aws.rekognition.model.Video.wrap(impl.video())
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.rekognition.model.primitives.ClientRequestToken(value)
      )
    override val faceMatchThreshold: Option[Percent] = scala
      .Option(impl.faceMatchThreshold())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val collectionId: CollectionId =
      zio.aws.rekognition.model.primitives.CollectionId(impl.collectionId())
    override val notificationChannel
        : Option[zio.aws.rekognition.model.NotificationChannel.ReadOnly] = scala
      .Option(impl.notificationChannel())
      .map(value => zio.aws.rekognition.model.NotificationChannel.wrap(value))
    override val jobTag: Option[JobTag] = scala
      .Option(impl.jobTag())
      .map(value => zio.aws.rekognition.model.primitives.JobTag(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StartFaceSearchRequest
  ): zio.aws.rekognition.model.StartFaceSearchRequest.ReadOnly = new Wrapper(
    impl
  )
}
