package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.JobId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartFaceDetectionResponse(jobId: Option[JobId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StartFaceDetectionResponse = {
    import StartFaceDetectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StartFaceDetectionResponse
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.StartFaceDetectionResponse.ReadOnly =
    zio.aws.rekognition.model.StartFaceDetectionResponse.wrap(buildAwsValue())
}
object StartFaceDetectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StartFaceDetectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StartFaceDetectionResponse =
      zio.aws.rekognition.model
        .StartFaceDetectionResponse(jobId.map(value => value))
    def jobId: Option[JobId]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StartFaceDetectionResponse
  ) extends zio.aws.rekognition.model.StartFaceDetectionResponse.ReadOnly {
    override val jobId: Option[JobId] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.rekognition.model.primitives.JobId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StartFaceDetectionResponse
  ): zio.aws.rekognition.model.StartFaceDetectionResponse.ReadOnly =
    new Wrapper(impl)
}
